const API = "https://bonjure.ru/claude-ext/api.php";
let token = "";
let history = [];

async function init() {
  const data = await chrome.storage.local.get(["token", "history"]);
  if (data.token) {
    token = data.token;
    history = data.history || [];
  } else {
    token = "user_" + Math.random().toString(36).substr(2, 12);
    await chrome.storage.local.set({ token });
  }
  document.getElementById("tokenInfo").textContent = token + " (клик = копировать)";
  document.getElementById("tokenInfo").onclick = () => {
    navigator.clipboard.writeText(token);
    document.getElementById("tokenInfo").textContent = "Скопировано! Отправьте боту @bonjureai_bot";
    setTimeout(() => {
      document.getElementById("tokenInfo").textContent = token + " (клик = копировать)";
    }, 2000);
  };
  document.getElementById("balance").onclick = () => {
    navigator.clipboard.writeText(token);
    alert("Токен скопирован: " + token + "\\n\\nОтправьте его боту @bonjureai_bot для привязки");
  };
  renderHistory();
  auth();
}

async function auth() {
  try {
    const r = await fetch(API, {
      method: "POST",
      headers: { "Content-Type": "application/json" },
      body: JSON.stringify({ action: "auth", token })
    });
    const d = await r.json();
    if (d.success) {
      document.getElementById("balance").textContent = formatNum(d.balance);
    }
  } catch (e) { console.error(e); }
}

function formatNum(n) {
  if (n >= 1000) return Math.round(n/1000) + "K";
  return n;
}

function renderHistory() {
  const chat = document.getElementById("chat");
  chat.innerHTML = history.map(m => 
    "<div class=\"msg " + m.role + "\">" + escapeHtml(m.content) + "</div>"
  ).join("");
  chat.scrollTop = chat.scrollHeight;
}

function escapeHtml(t) {
  return t.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/\\n/g,"<br>");
}

async function send() {
  const input = document.getElementById("input");
  const text = input.value.trim();
  if (!text) return;
  
  input.value = "";
  history.push({ role: "user", content: text });
  renderHistory();
  
  const btn = document.getElementById("send");
  btn.disabled = true;
  
  try {
    const r = await fetch(API, {
      method: "POST",
      headers: { "Content-Type": "application/json" },
      body: JSON.stringify({ action: "chat", token, message: text, history: history.slice(-10) })
    });
    const d = await r.json();
    if (d.success) {
      history.push({ role: "bot", content: d.response });
      document.getElementById("balance").textContent = formatNum(d.balance);
      await chrome.storage.local.set({ history: history.slice(-50) });
    } else {
      history.push({ role: "bot", content: "Ошибка: " + (d.error || "неизвестная") });
    }
  } catch (e) {
    history.push({ role: "bot", content: "Ошибка сети" });
  }
  
  btn.disabled = false;
  renderHistory();
}

document.getElementById("send").onclick = send;
document.getElementById("input").onkeypress = (e) => { if (e.key === "Enter") send(); };
init();
